// === EC View 수정본 (Download Audio 버튼 및 버튼 크기 통일 적용) ===
import { sendToWhisper, evaluateInterviewAnswer } from '../api.js';
import { setupRecording } from '../recorder.js';

let presentationText = '';
let countdownTimer = null;
const MAX_COUNTDOWN_TIME = 300;

export function renderECView() {
  const ecContainer = document.getElementById('ecContent');
  ecContainer.innerHTML = `
    <div>
      <p><strong>🎯 Topic:</strong> What can you do to change the world? (e.g., Steve Jobs and the smartphone)</p>
      <div class="controls-row">
        <button id="record" class="green">🎙️ Start Recording</button>
        <button id="stop" class="red" disabled>⏹️ Stop</button>
      </div>
      <div class="controls-row">
        <button id="submit" class="orange" style="min-width:120px;">📤 Submit for Evaluation</button>
        <button id="downloadFeedbackBtn" class="orange" disabled style="min-width:120px;">📁 Download Feedback</button>
        <button id="reset" class="orange" style="min-width:120px;">🔄 Reset</button>
      </div>

      <p id="recordTimerDisplay" style="font-size: 13px; color: #888;"></p>
      <audio id="audio" controls></audio>
      <div class="controls-row">
        <button id="downloadAudioBtn" class="orange" style="display: none;">🎧 Download Audio</button>
      </div>
      

      <h4>📝 Transcription</h4>
      <div id="ecHistory" style="background:#f9f9f9; padding:10px; border:1px solid #ccc; border-radius:6px; min-height: 100px;"></div>
      <h4>📊 Evaluation Feedback</h4>
      <pre id="ecFeedback"></pre>
    </div>
  `;

  const recordBtn = document.getElementById('record');
  const stopBtn = document.getElementById('stop');
  const submitBtn = document.getElementById('submit');
  const resetBtn = document.getElementById('reset');
  const feedbackBox = document.getElementById('ecFeedback');
  const historyBox = document.getElementById('ecHistory');
  const downloadBtn = document.getElementById('downloadFeedbackBtn');
  const audioDownloadBtn = document.getElementById('downloadAudioBtn');
  const downloadLink = document.createElement('a');
downloadLink.style.display = 'none';
downloadLink.setAttribute('download', 'EC_Audio.webm');
document.body.appendChild(downloadLink);

  setupRecording(recordBtn, stopBtn, document.getElementById('audio'), downloadLink, (blob) => {
    const audioUrl = URL.createObjectURL(blob);
    downloadLink.href = audioUrl;
    audioDownloadBtn.style.display = 'inline-block';
    audioDownloadBtn.onclick = () => downloadLink.click();
  });

  window.startCountdownTimer = function () {
    let remaining = MAX_COUNTDOWN_TIME;
    document.getElementById('recordTimerDisplay').textContent = `Time left: ${remaining}s`;
    countdownTimer = setInterval(() => {
      remaining--;
      document.getElementById('recordTimerDisplay').textContent = `Time left: ${remaining}s`;
      if (remaining <= 0) {
        clearInterval(countdownTimer);
        stopBtn.click();
        alert("Time's up! Recording stopped automatically.");
      }
    }, 1000);
  };

  window.stopCountdownTimer = function () {
    if (countdownTimer) clearInterval(countdownTimer);
    document.getElementById('recordTimerDisplay').textContent = '';
  };

  recordBtn.addEventListener('click', () => window.startCountdownTimer());
  stopBtn.addEventListener('click', window.stopCountdownTimer);

submitBtn.addEventListener('click', async () => {
  const blob = window.latestRecordingBlob;
  if (!blob) return alert("Please record your presentation first.");

  const transcript = await sendToWhisper(blob);
  presentationText = transcript;

  // 🚨 악의적 요청 차단 로직
  const bannedPhrases = [
    "prompt", "chatgpt", "gpt", "openai", "api key", "system prompt",
    "write me", "generate", "make a", "please write", "how do i", "code"
  ];
  const lower = transcript.toLowerCase();
  const isAbuse = bannedPhrases.some(p => lower.includes(p));

  if (isAbuse) {
    alert("⚠️ GPT 관련 명령어나 시스템 요청이 탐지되었습니다. 지정된 발표 주제에 맞춰 자연스럽게 응답해주세요.");
    return;
  }

  const bubble = document.createElement('div');
  bubble.className = 'bubble';
  bubble.style.cssText = 'background:#dcf8c6; padding:10px; border-radius:10px; margin-bottom:8px';
  bubble.textContent = transcript;
  historyBox.innerHTML = '';
  historyBox.appendChild(bubble);

  const evaluationPrompt = `
You are an English presentation evaluator. A student has given a 5-minute speech on the topic:
“What can you do to change the world?” using a specific example (e.g. Steve Jobs and the smartphone).

Evaluate their presentation using the following five criteria:
1. Relevance & Originality – Does the idea directly address the theme? Is it creative or unique?
2. Logical Structure – Is there a clear flow from introduction to conclusion?
3. Specificity & Real-World Example – Are real examples or before/after effects included?
4. Feasibility & Social Impact – Is the idea realistic? Does it have potential to impact society?
5. Delivery & Fluency – Is the English clear and confident?

Give a score out of 5 and provide specific strengths and improvement tips.`;

  const feedback = await evaluateInterviewAnswer(`${evaluationPrompt}\n\n${presentationText}`, 'ec');
  feedbackBox.textContent = feedback;
  downloadBtn.disabled = false;
});


  downloadBtn.addEventListener('click', () => {
    const feedbackText = feedbackBox.textContent;
    const converted = '\uFEFF' + feedbackText.replace(/\n/g, '\r\n');
    const blob = new Blob([converted], { type: 'text/plain;charset=utf-8' });
    const url = URL.createObjectURL(blob);
    const a = document.createElement('a');
    a.href = url;
    a.download = 'EC_Feedback.txt';
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
    URL.revokeObjectURL(url);
  });

  resetBtn.addEventListener('click', () => {
    presentationText = '';
    historyBox.innerHTML = '';
    feedbackBox.textContent = '';
    document.getElementById('recordTimerDisplay').textContent = '';
    window.stopCountdownTimer();
    downloadBtn.disabled = true;
    audioDownloadBtn.style.display = 'none';
  });
}
