// === EC, ERC, EAP View 전체 수정본 + 버튼 색상 그룹화 ===
import { sendToWhisper, evaluateInterviewAnswer } from '../api.js';
import { setupRecording } from '../recorder.js';

let presentationText = '';

export function renderEAPView() {
  const eapContainer = document.getElementById('eapContent');
  eapContainer.innerHTML = `
    <div>
      <p><strong>🎯 Topic:</strong> Give an academic presentation on a topic of your choice.</p>
      <div class="controls-row">
        <button id="record" class="green">🎙️ Start Recording</button>
        <button id="stop" class="red" disabled>⏹️ Stop</button>
      </div>
      <div class="controls-row">
        <button id="submit" class="orange">📤 Submit for Evaluation</button>
        <button id="downloadFeedbackBtn" class="orange" disabled>📁 Download Feedback</button>
        <button id="reset" class="orange">🔄 Reset</button>
      </div>

      <p id="recordTimerDisplay" style="font-size: 13px; color: #888;"></p>
      <audio id="audio" controls></audio>
      <a id="downloadLink" style="display: none;" download>⬇️ Download</a>
      <h4>📝 EAP Presentation Transcript</h4>
      <div id="eapHistory" style="background:#f9f9f9; padding:10px; border:1px solid #ccc; border-radius:6px; min-height: 100px;"></div>
      <h4>📊 Academic Evaluation Feedback</h4>
      <pre id="eapFeedback"></pre>
    </div>
  `;

  const recordBtn = document.getElementById('record');
  const stopBtn = document.getElementById('stop');
  const submitBtn = document.getElementById('submit');
  const resetBtn = document.getElementById('reset');
  const feedbackBox = document.getElementById('eapFeedback');
  const historyBox = document.getElementById('eapHistory');
  const downloadBtn = document.getElementById('downloadFeedbackBtn');

  setupRecording(recordBtn, stopBtn, document.getElementById('audio'), document.getElementById('downloadLink'));

  recordBtn.addEventListener('click', () => {
    document.getElementById('recordTimerDisplay').textContent = 'Recording...';
  });

  stopBtn.addEventListener('click', () => {
    document.getElementById('recordTimerDisplay').textContent = '';
  });

 submitBtn.addEventListener('click', async () => {
  const blob = window.latestRecordingBlob;
  if (!blob) return alert("Please record your presentation first.");

  const transcript = await sendToWhisper(blob);

  // 🚫 악의적 응답 사전 차단
  const bannedPhrases = [
    "prompt", "chatgpt", "gpt", "openai", "api key", "system prompt",
    "write me", "generate", "make a", "please write", "how do i", "code"
  ];
  const lower = transcript.toLowerCase();
  const isAbuse = bannedPhrases.some(p => lower.includes(p));

  if (isAbuse) {
    alert("⚠️ 시스템 관련 명령어나 GPT 요청이 탐지되었습니다. 주제에 맞는 학문적 발표 내용을 말씀해주세요.");
    return;
  }

  presentationText = transcript;

  const bubble = document.createElement('div');
  bubble.className = 'bubble';
  bubble.style.cssText = 'background:#dcf8c6; padding:10px; border-radius:10px; margin-bottom:8px';
  bubble.textContent = transcript;
  historyBox.innerHTML = '';
  historyBox.appendChild(bubble);

  const evaluationPrompt = `
You are evaluating a student's academic presentation.

The student is expected to demonstrate clear structure, argumentation, use of academic language, and support with data or examples.

Assess the presentation using these criteria:

1. Structure – clear introduction, main points, and conclusion
2. Clarity – logical flow, transitions, and cohesion
3. Argumentation – relevance and strength of arguments
4. Academic Style – vocabulary, tone, and formality
5. Support – use of data, examples, or sources

Provide a score out of 5 and summarize key strengths and areas for improvement.`;

  const feedback = await evaluateInterviewAnswer(`${evaluationPrompt}\n\n${presentationText}`, 'eap');
  feedbackBox.textContent = feedback;
  downloadBtn.disabled = false;
});


  downloadBtn.addEventListener('click', () => {
    const feedbackText = feedbackBox.textContent;
    const converted = '\uFEFF' + feedbackText.replace(/\n/g, '\r\n');
    const blob = new Blob([converted], { type: 'text/plain;charset=utf-8' });
    const url = URL.createObjectURL(blob);
    const a = document.createElement('a');
    a.href = url;
    a.download = 'EAP_Feedback.txt';
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
    URL.revokeObjectURL(url);
  });

  resetBtn.addEventListener('click', () => {
    presentationText = '';
    historyBox.innerHTML = '';
    feedbackBox.textContent = '';
    document.getElementById('recordTimerDisplay').textContent = '';
    downloadBtn.disabled = true;
  });
}