// chrome.storage 관련 함수
// 녹음 URL, 분석 결과 등 저장 & 불러오기
// chrome.storage.local 사용, 저장량 관리

async function saveAudio(blob) {
  const arrayBuffer = await blob.arrayBuffer();
  const uint8Array = new Uint8Array(arrayBuffer);

  // ✅ JSON으로 저장 가능하도록 배열로 변환
  const audioArray = Array.from(uint8Array);

  chrome.storage.local.set({ interviewAudio: audioArray }, () => {
    console.log("🎧 오디오 저장 완료");
  });
}

function loadAudio(callback) {
  chrome.storage.local.get("interviewAudio", (data) => {
    if (data.interviewAudio) {
      // ✅ 다시 Uint8Array로 복원
      const uint8Array = new Uint8Array(data.interviewAudio);
      const blob = new Blob([uint8Array], { type: "audio/webm" });
      const url = URL.createObjectURL(blob);
      callback(url);
    }
  });
}
