// recorder.js

let mediaRecorder;
let audioChunks = [];

export function setupRecording(recordBtn, stopBtn, audioElement, downloadLink, onRecordingComplete) {
  recordBtn.addEventListener('click', async () => {
    try {
      const stream = await navigator.mediaDevices.getUserMedia({ audio: true });
      mediaRecorder = new MediaRecorder(stream);
      audioChunks = [];

      mediaRecorder.ondataavailable = event => {
        audioChunks.push(event.data);
      };

      mediaRecorder.onstop = () => {
        const audioBlob = new Blob(audioChunks, { type: 'audio/webm' });
        window.latestRecordingBlob = audioBlob;

        const audioUrl = URL.createObjectURL(audioBlob);
        audioElement.src = audioUrl;
        audioElement.style.display = 'block';

        downloadLink.href = audioUrl;
        downloadLink.style.display = 'inline-block';

        // ✅ 콜백 호출 추가: ef.js 쪽 다운로드 버튼 활성화 처리
        if (typeof onRecordingComplete === 'function') {
          onRecordingComplete(audioBlob);
        }
      };

      mediaRecorder.onstart = () => {
        if (typeof window.startRecordingTimer === 'function') {
          window.startRecordingTimer();
        }
      };

      mediaRecorder.start();
      recordBtn.disabled = true;
      stopBtn.disabled = false;
    } catch (err) {
      console.error("🎤 마이크 권한 오류:", err);
      alert("마이크 권한이 필요합니다. 브라우저에서 허용을 눌러주세요.");
    }
  });

  stopBtn.addEventListener('click', () => {
    if (mediaRecorder && mediaRecorder.state !== 'inactive') {
      mediaRecorder.stop();
      recordBtn.disabled = false;
      stopBtn.disabled = true;

      if (typeof window.stopRecordingTimer === 'function') {
        window.stopRecordingTimer();
      }      
    }
  });
}
