// popup.js

import { renderEFView } from './views/ef.js';
import { renderECView } from './views/ec.js';
import { renderERCView } from './views/erc.js';
import { renderEAPView } from './views/eap.js';

// 🔐 마이크 권한 사전 체크 및 요청 페이지 오픈
navigator.permissions?.query({ name: 'microphone' }).then(result => {
  if (result.state === 'denied' || result.state === 'prompt') {
    window.open('mic-permission.html', '_blank', 'width=480,height=320');
  }
});

const classSelect = document.getElementById('classSelect');
const startBtn = document.getElementById('startClassBtn');
const views = {
  ef: document.getElementById('efView'),
  ec: document.getElementById('ecView'),
  erc: document.getElementById('ercView'),
  eap: document.getElementById('eapView')
};

// 탭 클릭 시 선택값 업데이트
document.querySelectorAll('.class-option').forEach(option => {
  option.addEventListener('click', () => {
    document.querySelectorAll('.class-option').forEach(el => el.classList.remove('selected'));
    option.classList.add('selected');
    document.getElementById('classSelect').value = option.dataset.class;
  });
});

startBtn.addEventListener('click', () => {
  const selectedTab = document.querySelector('.class-option.selected');
  if (!selectedTab) {
    alert("먼저 수업 유형(EF, EC, ERC, EAP)을 선택해주세요.");
    return;
  }

  const selected = selectedTab.dataset.class;

  document.getElementById('classSelection').style.display = 'none';
  Object.values(views).forEach(view => view.style.display = 'none');
  views[selected].style.display = 'block';

  switch (selected) {
    case 'ef':
      renderEFView();
      break;
    case 'ec':
      renderECView();
      break;
    case 'erc':
      renderERCView();
      break;
    case 'eap':
      renderEAPView();
      break;
  }
});
